#pragma once
#include "Model.h"
#include "PointLight.h"

class Jukebox : public Model
{
	public:
		Jukebox();
		~Jukebox();

		//Overrides
		bool loadMTL(char* modelFilename, char* mtlFilename, int renderingShape = GL_TRIANGLES) override;
		void render(Vector3 position = Vector3(5.0f, 1.0f, -4.0f)) override;

		void SetLights(PointLight* one, PointLight* two);	//Sets the lights that affect the jukebox's shadow

	private:
		PointLight* _PointOne;
		PointLight* _PointTwo;
};

